#ifndef _LINUX_MM_BACKPORT_TO_2_6_15
#define _LINUX_MM_BACKPORT_TO_2_6_15

#include_next <linux/mm.h>

/*
	See commits
		41d78ba55037468e6c86c53e3076d1a74841de39
		d98c7a09843621f1b145ca5ae8ed03ff04085edb
	for an explanation.
*/

static inline int backport_set_page_dirty_lock(struct page *page)
{
	if (!PageCompound(page))
		return set_page_dirty_lock(page);

	return 0;
}

#define set_page_dirty_lock backport_set_page_dirty_lock

#endif /* _LINUX_MM_BACKPORT_TO_2_6_15 */
